(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     10457,        303]
NotebookOptionsPosition[     10023,        287]
NotebookOutlinePosition[     10493,        305]
CellTagsIndexPosition[     10450,        302]
WindowTitle->Basic argon EoS with units
WindowFrame->Palette*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       StyleBox[
       "\"NewEoSArgon guide\"", 12, FontFamily -> "Times", StripOnInput -> 
        False], "paclet:NewEoSArgon/guide/NewEoSArgon", 
       "paclet:NewEoSArgon/guide/NewEoSArgon", "Link", {"HyperlinkActive"}, 
       BaseStyle -> {FontColor -> GrayLevel[0]}, Appearance -> "Palette", 
       ImageSize -> 140},
      "HyperlinkTemplate"]},
    {
     TemplateBox[{
       StyleBox[
       "\"Argon Function Listing\"", 12, FontFamily -> "Times", StripOnInput -> 
        False], "paclet:NewEoSArgon/ref/NewEoSArgonFunctions", 
       "paclet:NewEoSArgon/ref/NewEoSArgonFunctions", "Link", {
       "HyperlinkActive"}, BaseStyle -> {FontColor -> GrayLevel[0]}, 
       Appearance -> "Palette", ImageSize -> 140},
      "HyperlinkTemplate"]},
    {
     ButtonBox[
      StyleBox[
       RowBox[{
        StyleBox["U",
         FontSlant->"Italic"], "/", 
        StyleBox["RT",
         FontSlant->"Italic"]}],
       StripOnInput->False,
       FontFamily->"Times",
       FontSize->12],
      Appearance->"FramedPalette",
      BaseStyle->"Paste",
      ButtonData->RowBox[{"UtotalAdimNv", "[", 
         RowBox[{
           RowBox[{"QuantityMagnitude", "[", 
             
             TemplateBox[{"T", "\"K\"", "kelvins", "\"Kelvins\""}, "Quantity",
               SyntaxForm -> Mod], "]"}], ",", 
           RowBox[{"QuantityMagnitude", "[", 
             TemplateBox[{"rho", 
               
               RowBox[{
                "\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
                 SuperscriptBox["\"cm\"", "3"]}], 
               "grams per centimeter cubed", 
               FractionBox["\"Grams\"", 
                SuperscriptBox["\"Centimeters\"", "3"]]}, "Quantity", 
              SyntaxForm -> Mod], "]"}]}], "]"}],
      ImageSize->100]},
    {
     ButtonBox[
      StyleBox[
       RowBox[{
        StyleBox["S",
         FontSlant->"Italic"], "/", 
        StyleBox["R",
         FontSlant->"Italic"]}],
       StripOnInput->False,
       FontFamily->"Times",
       FontSize->12],
      Appearance->"FramedPalette",
      BaseStyle->"Paste",
      ButtonData->RowBox[{"StotalAdimNv", "[", 
         RowBox[{
           RowBox[{"QuantityMagnitude", "[", 
             
             TemplateBox[{"T", "\"K\"", "kelvins", "\"Kelvins\""}, "Quantity",
               SyntaxForm -> Mod], "]"}], ",", 
           RowBox[{"QuantityMagnitude", "[", 
             TemplateBox[{"rho", 
               
               RowBox[{
                "\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
                 SuperscriptBox["\"cm\"", "3"]}], 
               "grams per centimeter cubed", 
               FractionBox["\"Grams\"", 
                SuperscriptBox["\"Centimeters\"", "3"]]}, "Quantity", 
              SyntaxForm -> Mod], "]"}]}], "]"}],
      ImageSize->100]},
    {
     ButtonBox[
      StyleBox[
       RowBox[{
        StyleBox["H",
         FontSlant->"Italic"], "/", 
        StyleBox["RT",
         FontSlant->"Italic"]}],
       StripOnInput->False,
       FontFamily->"Times",
       FontSize->12],
      Appearance->"FramedPalette",
      BaseStyle->"Paste",
      ButtonData->RowBox[{"HtotalAdimNv", "[", 
         RowBox[{
           RowBox[{"QuantityMagnitude", "[", 
             
             TemplateBox[{"T", "\"K\"", "kelvins", "\"Kelvins\""}, "Quantity",
               SyntaxForm -> Mod], "]"}], ",", 
           RowBox[{"QuantityMagnitude", "[", 
             TemplateBox[{"rho", 
               
               RowBox[{
                "\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
                 SuperscriptBox["\"cm\"", "3"]}], 
               "grams per centimeter cubed", 
               FractionBox["\"Grams\"", 
                SuperscriptBox["\"Centimeters\"", "3"]]}, "Quantity", 
              SyntaxForm -> Mod], "]"}]}], "]"}],
      ImageSize->100]},
    {
     ButtonBox[
      StyleBox[
       RowBox[{
        StyleBox["F",
         FontSlant->"Italic"], "/", 
        StyleBox["RT",
         FontSlant->"Italic"]}],
       StripOnInput->False,
       FontFamily->"Times",
       FontSize->12],
      Appearance->"FramedPalette",
      BaseStyle->"Paste",
      ButtonData->RowBox[{"FtotalAdimNv", "[", 
         RowBox[{
           RowBox[{"QuantityMagnitude", "[", 
             
             TemplateBox[{"T", "\"K\"", "kelvins", "\"Kelvins\""}, "Quantity",
               SyntaxForm -> Mod], "]"}], ",", 
           RowBox[{"QuantityMagnitude", "[", 
             TemplateBox[{"rho", 
               
               RowBox[{
                "\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
                 SuperscriptBox["\"cm\"", "3"]}], 
               "grams per centimeter cubed", 
               FractionBox["\"Grams\"", 
                SuperscriptBox["\"Centimeters\"", "3"]]}, "Quantity", 
              SyntaxForm -> Mod], "]"}]}], "]"}],
      ImageSize->100]},
    {
     ButtonBox[
      StyleBox[
       StyleBox["Z",
        FontSlant->"Italic"],
       StripOnInput->False,
       FontFamily->"Times",
       FontSize->12],
      Appearance->"FramedPalette",
      BaseStyle->"Paste",
      ButtonData->RowBox[{"ZtotalNv", "[", 
         RowBox[{
           RowBox[{"QuantityMagnitude", "[", 
             
             TemplateBox[{"T", "\"K\"", "kelvins", "\"Kelvins\""}, "Quantity",
               SyntaxForm -> Mod], "]"}], ",", 
           RowBox[{"QuantityMagnitude", "[", 
             TemplateBox[{"rho", 
               
               RowBox[{
                "\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
                 SuperscriptBox["\"cm\"", "3"]}], 
               "grams per centimeter cubed", 
               FractionBox["\"Grams\"", 
                SuperscriptBox["\"Centimeters\"", "3"]]}, "Quantity", 
              SyntaxForm -> Mod], "]"}]}], "]"}],
      ImageSize->100]},
    {
     ButtonBox[
      StyleBox[
       RowBox[{
        StyleBox[
         SubscriptBox["C", "V"],
         FontSlant->"Italic"], "/", 
        StyleBox["R",
         FontSlant->"Italic"]}],
       StripOnInput->False,
       FontFamily->"Times",
       FontSize->12],
      Appearance->"FramedPalette",
      BaseStyle->"Paste",
      ButtonData->RowBox[{"CVAdimNv", "[", 
         RowBox[{
           RowBox[{"QuantityMagnitude", "[", 
             
             TemplateBox[{"T", "\"K\"", "kelvins", "\"Kelvins\""}, "Quantity",
               SyntaxForm -> Mod], "]"}], ",", 
           RowBox[{"QuantityMagnitude", "[", 
             TemplateBox[{"rho", 
               
               RowBox[{
                "\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
                 SuperscriptBox["\"cm\"", "3"]}], 
               "grams per centimeter cubed", 
               FractionBox["\"Grams\"", 
                SuperscriptBox["\"Centimeters\"", "3"]]}, "Quantity", 
              SyntaxForm -> Mod], "]"}]}], "]"}],
      ImageSize->100]},
    {
     ButtonBox[
      StyleBox[
       RowBox[{
        StyleBox[
         SubscriptBox["C", "P"],
         FontSlant->"Italic"], "/", 
        StyleBox["R",
         FontSlant->"Italic"]}],
       StripOnInput->False,
       FontFamily->"Times",
       FontSize->12],
      Appearance->"FramedPalette",
      BaseStyle->"Paste",
      ButtonData->RowBox[{"CpAdimNv", "[", 
         RowBox[{
           RowBox[{"QuantityMagnitude", "[", 
             
             TemplateBox[{"T", "\"K\"", "kelvins", "\"Kelvins\""}, "Quantity",
               SyntaxForm -> Mod], "]"}], ",", 
           RowBox[{"QuantityMagnitude", "[", 
             TemplateBox[{"rho", 
               
               RowBox[{
                "\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
                 SuperscriptBox["\"cm\"", "3"]}], 
               "grams per centimeter cubed", 
               FractionBox["\"Grams\"", 
                SuperscriptBox["\"Centimeters\"", "3"]]}, "Quantity", 
              SyntaxForm -> Mod], "]"}]}], "]"}],
      ImageSize->100]},
    {
     ButtonBox[
      StyleBox[
       RowBox[{
        StyleBox["\[Mu]",
         FontSlant->"Plain"], 
        StyleBox["R",
         FontSlant->"Italic"], "\[Rho]"}],
       StripOnInput->False,
       FontFamily->"Times",
       FontSize->12],
      Appearance->"FramedPalette",
      BaseStyle->"Paste",
      ButtonData->RowBox[{"CoefJouleThomsonAdimNv", "[", 
         RowBox[{
           RowBox[{"QuantityMagnitude", "[", 
             
             TemplateBox[{"T", "\"K\"", "kelvins", "\"Kelvins\""}, "Quantity",
               SyntaxForm -> Mod], "]"}], ",", 
           RowBox[{"QuantityMagnitude", "[", 
             TemplateBox[{"rho", 
               
               RowBox[{
                "\"g\"", "\[InvisibleSpace]", "\"/\"", "\[InvisibleSpace]", 
                 SuperscriptBox["\"cm\"", "3"]}], 
               "grams per centimeter cubed", 
               FractionBox["\"Grams\"", 
                SuperscriptBox["\"Centimeters\"", "3"]]}, "Quantity", 
              SyntaxForm -> Mod], "]"}]}], "]"}],
      ImageSize->100]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Center}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0.1}}}],
  "Column"]],ExpressionUUID->"9b7e0a46-7e9a-486f-aaf7-e558ff2066ab"]
},
WindowSize->All,
WindowMargins->{{Automatic, 152.4000000000001}, {Automatic, 45}},
WindowElements->{},
WindowTitle->"Basic argon EoS with units",
FrontEndVersion->"13.3 pour Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->"Palette.nb",
ExpressionUUID->"f322fb46-a256-44b2-8e5a-fc9a94dedcee"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[599, 21, 9420, 264, 207, InheritFromParent,ExpressionUUID->"9b7e0a46-7e9a-486f-aaf7-e558ff2066ab"]
}
]
*)

(* End of internal cache information *)

